/*
 * Decompiled with CFR 0.152.
 */
package net.dragonloot.entity.model;

import com.google.common.collect.ImmutableList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

@Environment(value=EnvType.CLIENT)
public class DragonElytraEntityModel<T extends LivingEntity>
extends AgeableListModel<T> {
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public DragonElytraEntityModel(ModelPart root) {
        this.leftWing = root.m_171324_("left_wing");
        this.rightWing = root.m_171324_("right_wing");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        CubeDeformation dilation = new CubeDeformation(1.0f);
        modelPartData.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-10.0f, 0.0f, 0.0f, 20.0f, 21.0f, 2.0f, dilation), PartPose.m_171423_((float)5.0f, (float)0.0f, (float)0.0f, (float)0.2617994f, (float)0.0f, (float)-0.2617994f));
        modelPartData.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171480_().m_171488_(-10.0f, 0.0f, 0.0f, 20.0f, 21.0f, 2.0f, dilation), PartPose.m_171423_((float)-5.0f, (float)0.0f, (float)0.0f, (float)0.2617994f, (float)0.0f, (float)0.2617994f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.leftWing, (Object)this.rightWing);
    }

    public void setAngles(T livingEntity, float f, float g, float h, float i, float j) {
        float k = 0.2617994f;
        float l = -0.2617994f;
        float m = 0.0f;
        float n = 0.0f;
        if (livingEntity.m_21255_()) {
            float o = 1.0f;
            Vec3 vec3d = livingEntity.m_20184_();
            if (vec3d.f_82480_ < 0.0) {
                Vec3 vec3d2 = vec3d.m_82541_();
                o = 1.0f - (float)Math.pow(-vec3d2.f_82480_, 1.5);
            }
            k = o * 0.34906584f + (1.0f - o) * k;
            l = o * -1.5707964f + (1.0f - o) * l;
        } else if (livingEntity.m_6047_()) {
            k = 0.6981317f;
            l = -0.7853982f;
            m = 3.0f;
            n = 0.08726646f;
        }
        this.leftWing.f_104201_ = m;
        if (livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractClientPlayerEntity = (AbstractClientPlayer)livingEntity;
            abstractClientPlayerEntity.f_108542_ = (float)((double)abstractClientPlayerEntity.f_108542_ + (double)(k - abstractClientPlayerEntity.f_108542_) * 0.1);
            abstractClientPlayerEntity.f_108543_ = (float)((double)abstractClientPlayerEntity.f_108543_ + (double)(n - abstractClientPlayerEntity.f_108543_) * 0.1);
            abstractClientPlayerEntity.f_108544_ = (float)((double)abstractClientPlayerEntity.f_108544_ + (double)(l - abstractClientPlayerEntity.f_108544_) * 0.1);
            this.leftWing.f_104203_ = abstractClientPlayerEntity.f_108542_;
            this.leftWing.f_104204_ = abstractClientPlayerEntity.f_108543_;
            this.leftWing.f_104205_ = abstractClientPlayerEntity.f_108544_;
        } else {
            this.leftWing.f_104203_ = k;
            this.leftWing.f_104205_ = l;
            this.leftWing.f_104204_ = n;
        }
        this.rightWing.f_104204_ = -this.leftWing.f_104204_;
        this.rightWing.f_104201_ = this.leftWing.f_104201_;
        this.rightWing.f_104203_ = this.leftWing.f_104203_;
        this.rightWing.f_104205_ = -this.leftWing.f_104205_;
    }
}

